/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog.wizard;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class VWBaseWizardDialog
extends VWModalDialog
implements ActionListener,
IVWFrameInterface {
    protected IVWWizardPanel[] m_panelList = null;
    protected int m_nCurrentPanelIndex = -1;
    private SimpleAttributeSet m_boldBlackText = null;
    private SimpleAttributeSet m_plainBlackText = null;
    private JTextPane m_descriptionTextPane = null;
    protected JPanel m_mainPanel = null;
    protected JPanel m_topPanel = null;
    protected CardLayout m_cardLayout = null;
    protected JButton m_backButton = null;
    protected JButton m_nextButton = null;
    protected JButton m_finishButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;
    protected JButton m_currentDefaultButton = null;

    public VWBaseWizardDialog(Frame parentFrame) {
        super(parentFrame);
    }

    public void setNextPanelDisplayState(boolean bDisplay) {
        if (this.m_panelList != null && this.m_panelList.length > this.m_nCurrentPanelIndex + 1) {
            this.m_panelList[this.m_nCurrentPanelIndex + 1].setDisplayState(bDisplay);
        }
    }

    public void releaseResources() {
        if (this.m_panelList != null) {
            for (int i = 0; i < this.m_panelList.length; ++i) {
                this.m_panelList[i].releaseResources();
                this.m_panelList[i] = null;
            }
            this.m_panelList = null;
        }
        this.m_mainPanel = null;
        this.m_cardLayout = null;
        this.m_boldBlackText = null;
        this.m_plainBlackText = null;
        this.m_descriptionTextPane = null;
        if (this.m_backButton != null) {
            this.m_backButton.removeActionListener(this);
            this.m_backButton.removeAll();
            this.m_backButton = null;
        }
        if (this.m_nextButton != null) {
            this.m_nextButton.removeActionListener(this);
            this.m_nextButton.removeAll();
            this.m_nextButton = null;
        }
        if (this.m_finishButton != null) {
            this.m_finishButton.removeActionListener(this);
            this.m_finishButton.removeAll();
            this.m_finishButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_backButton)) {
            this.moveBack();
        } else if (object.equals(this.m_nextButton)) {
            this.moveNext();
        } else if (object.equals(this.m_finishButton)) {
            try {
                IVWWizardPanel panel = this.m_panelList[this.m_nCurrentPanelIndex];
                panel.checkForErrors();
            }
            catch (Exception ex) {
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
                return;
            }
            try {
                if (this.performFinishAction()) {
                    this.m_nExitStatus = 0;
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
            }
        } else if (object.equals(this.m_cancelButton)) {
            this.exitDialog();
        } else if (object.equals(this.m_helpButton)) {
            this.showHelp();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.exitDialog();
    }

    protected void initialize(Icon image) {
        this.createControls(image);
        this.setLocationRelativeTo(this.getParent());
        this.m_nExitStatus = 1;
        this.m_currentDefaultButton = this.m_nextButton;
    }

    protected abstract void addPanels();

    protected abstract String getDialogDimensionString();

    protected abstract String getDialogTitle();

    protected abstract String getHelpPage();

    protected abstract boolean performFinishAction();

    private void createControls(Icon image) {
        try {
            this.setTitle(this.getDialogTitle());
            Dimension dim = VWStringUtils.stringToDimension(this.getDialogDimensionString());
            if (dim == null) {
                dim = new Dimension(650, 400);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setDefaultCloseOperation(0);
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getDescriptionPanel(image), "First");
            panel.add((Component)this.getMainPanel(), "Center");
            panel.add((Component)this.getButtonPanel(), "Last");
            this.getContentPane().add(panel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDescriptionPanel(Icon image) {
        try {
            this.m_topPanel = new JPanel();
            this.m_topPanel.setLayout(new BoxLayout(this.m_topPanel, 2));
            this.m_topPanel.setBackground(SystemColor.text);
            this.m_topPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder));
            this.m_descriptionTextPane = new JTextPane();
            this.m_descriptionTextPane.setBackground(SystemColor.text);
            this.m_descriptionTextPane.setEditable(false);
            this.m_descriptionTextPane.setFocusable(false);
            this.m_boldBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_boldBlackText, SystemColor.textText);
            StyleConstants.setBold(this.m_boldBlackText, true);
            this.m_plainBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_plainBlackText, SystemColor.textText);
            StyleConstants.setBold(this.m_plainBlackText, false);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextPane, this.m_topPanel, VWResource.s_description, VWResource.s_description);
            this.m_descriptionTextPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_topPanel.add(Box.createRigidArea(new Dimension(15, 60)));
            this.m_topPanel.add(this.m_descriptionTextPane);
            if (image != null) {
                this.m_topPanel.add(new JLabel(image));
                this.m_topPanel.add(Box.createRigidArea(new Dimension(15, 60)));
            }
            return this.m_topPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMainPanel() {
        try {
            this.m_cardLayout = new CardLayout();
            this.m_mainPanel = new JPanel(this.m_cardLayout);
            this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.addPanels();
            if (this.m_panelList != null && this.m_panelList.length > 0) {
                this.m_nCurrentPanelIndex = 0;
                IVWWizardPanel panel = this.m_panelList[this.m_nCurrentPanelIndex];
                this.updateDescription(panel.getTitle(), panel.getInstructions());
                panel.initialize();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_mainPanel;
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel(new FlowLayout());
            this.m_backButton = new JButton(VWResource.s_backArrow);
            this.m_backButton.setName("m_backButton_VWBaseWizardDialog");
            this.m_backButton.setEnabled(false);
            this.m_backButton.addActionListener(this);
            panel.add(this.m_backButton);
            this.m_nextButton = new JButton(VWResource.s_nextArrow);
            this.m_nextButton.setName("m_nextButton_VWBaseWizardDialog");
            this.m_nextButton.addActionListener(this);
            panel.add(this.m_nextButton);
            this.m_finishButton = new JButton(VWResource.s_finish);
            this.m_finishButton.setName("m_finishButton_VWBaseWizardDialog");
            this.m_finishButton.setEnabled(false);
            this.m_finishButton.addActionListener(this);
            panel.add(this.m_finishButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWBaseWizardDialog");
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_ellipse.toString(VWResource.s_help));
            this.m_helpButton.setName("m_helpButton_VWBaseWizardDialog");
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            VWAccessibilityHelper.setAccessibility(this.m_backButton, panel, VWResource.s_back, VWResource.s_back);
            this.m_backButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_nextButton, panel, VWResource.s_next, VWResource.s_next);
            this.m_nextButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_finishButton, panel, VWResource.s_finish, VWResource.s_finish);
            this.m_finishButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, panel, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, panel, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void updateDescription(String title, String instructions) {
        try {
            if (this.m_descriptionTextPane != null) {
                this.m_descriptionTextPane.setText(null);
                Document descriptionDocument = this.m_descriptionTextPane.getDocument();
                descriptionDocument.insertString(descriptionDocument.getLength(), title + "\n", this.m_boldBlackText);
                descriptionDocument.insertString(descriptionDocument.getLength(), instructions, this.m_plainBlackText);
                VWAccessibilityHelper.setAccessibility(this.m_descriptionTextPane, this.m_topPanel, title, instructions);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void moveBack() {
        try {
            if (this.m_panelList != null && this.m_nCurrentPanelIndex > 0) {
                if (this.m_nCurrentPanelIndex > 0 && this.m_panelList[this.m_nCurrentPanelIndex - 1] != null && !this.m_panelList[this.m_nCurrentPanelIndex - 1].getDisplayState()) {
                    this.m_cardLayout.previous(this.m_mainPanel);
                    --this.m_nCurrentPanelIndex;
                }
                this.m_cardLayout.previous(this.m_mainPanel);
                --this.m_nCurrentPanelIndex;
                IVWWizardPanel panel = this.m_panelList[this.m_nCurrentPanelIndex];
                this.updateDescription(panel.getTitle(), panel.getInstructions());
                this.m_backButton.setEnabled(this.m_nCurrentPanelIndex > 0);
                this.m_nextButton.setEnabled(true);
                this.m_finishButton.setEnabled(panel.getEnableFinishButton() || this.m_nCurrentPanelIndex == this.m_panelList.length - 1);
                this.m_currentDefaultButton = this.m_nextButton;
                this.m_currentDefaultButton.requestFocus();
                panel.initialize();
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveNext() {
        block9: {
            try {
                if (this.m_panelList == null || this.m_nCurrentPanelIndex >= this.m_panelList.length - 1) break block9;
                IVWWizardPanel panel = this.m_panelList[this.m_nCurrentPanelIndex];
                try {
                    try {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        panel.checkForErrors();
                    }
                    catch (Exception ex) {
                        VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
                        Object var4_4 = null;
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                this.setCursor(Cursor.getDefaultCursor());
                if (this.m_panelList[this.m_nCurrentPanelIndex + 1] != null && !this.m_panelList[this.m_nCurrentPanelIndex + 1].getDisplayState()) {
                    this.m_cardLayout.next(this.m_mainPanel);
                    ++this.m_nCurrentPanelIndex;
                }
                this.m_cardLayout.next(this.m_mainPanel);
                ++this.m_nCurrentPanelIndex;
                panel = this.m_panelList[this.m_nCurrentPanelIndex];
                this.updateDescription(panel.getTitle(), panel.getInstructions());
                this.m_backButton.setEnabled(true);
                this.m_nextButton.setEnabled(this.m_nCurrentPanelIndex != this.m_panelList.length - 1);
                this.m_finishButton.setEnabled(panel.getEnableFinishButton() || this.m_nCurrentPanelIndex == this.m_panelList.length - 1);
                if (this.m_nCurrentPanelIndex == this.m_panelList.length - 1) {
                    this.m_currentDefaultButton = this.m_finishButton;
                }
                if (this.m_currentDefaultButton != null) {
                    this.m_currentDefaultButton.requestFocus();
                }
                panel.initialize();
            }
            catch (Exception ex) {
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
            }
        }
    }

    private void showHelp() {
        String helpPage = this.getHelpPage();
        String label = this.m_panelList[this.m_nCurrentPanelIndex].getHelpTopic();
        VWHelp.displayPage(helpPage + label);
    }

    private void exitDialog() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int nReply = VWMessageDialog.showConfirmDialog(this, VWResource.s_okToExitWizard, this.getDialogTitle(), 3);
            if (nReply == 2) {
                return;
            }
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

